#include "stdafx.h"
#include "critter2.h"
#include "random.h" //For

//===========Switches
//#define CRUDE_WANDER


//Helper------------------------
Vector2 rrRandomunitvector() //Code in CRITTER4.CPP
{
	Real x, y;
	rrRandomunitpair(&x, &y);
	return Vector2(x, y);
}

extern void ErrorBox(char* box_caption, char* error_message);
	//Code for this guy is in CMEMORYDC2.CPP

//=========================Critter============================

Critter::Critter():
_world(NULL),
_icon_fullsize(NULL),
_scalex(1.0),
_scaley(1.0),
_owner(NULL),
_alive(TRUE),
_point_position(0,0),
_position(0.0,0.0),
_minspeed(MIN_SPEED),
_maxspeed(MAX_SPEED),
_direction(1.0, 0.0),
_speed(1.0),
_velocity(1.0, 0.0),
_acceleration(0.0, 0.0),
_mass(1.0),
_radius(0.3),
_score(0)
{  
	_icon = new cTransparentMemoryDC(); /* This makes a 1*1 bitmap.  I will resize
		it in my CAlifeView::OnSize calls to scaleIcon */
}

void Critter::RandomizePositionVelocity()
{
	_position = _world->box().Randomlocation();
	_direction = rrRandomunitvector();
	_speed = rrRandomreal(_minspeed, _maxspeed);
	_velocity = _speed * _direction;
}

BOOL Critter::_RealToPixel(const Frame &frame)
{ 
	int x, y;
	BOOL success;
	success = frame.RealToPixel(_position.x(), _position.y(), &x, &y);
	_point_position.x = x;
	_point_position.y = y;
	return success;
}

#define MINICONSIZE 2

void Critter::scaleIcon(Real scalefactor_x, Real scalefactor_y)
{
	_scalex = scalefactor_x;
	_scaley = scalefactor_y;
	int sizex = int(scalefactor_x * _icon_fullsize->cx());
	int sizey = int(scalefactor_y * _icon_fullsize->cy());
	if (sizex < MINICONSIZE)
		sizex = MINICONSIZE;
	if (sizey < MINICONSIZE)
		sizey = MINICONSIZE;
	_icon->setSize(sizex, sizey);
	_icon_fullsize->stretchToIcon(_icon);
}

void Critter::SetIcon(cTransparentMemoryDC *icon)
{
	_icon_fullsize = icon;
	scaleIcon(_scalex, _scaley);
}

void Critter::Show(CDC *pDC, const Frame &frame)
{
	_RealToPixel(frame);
	if (!_icon)
		return;
	CPoint icon_corner(_icon->cx()/2, _icon->cy()/2);
	_icon->pasteTo(pDC, _point_position - icon_corner);
 //Center image around _position.
}

void Critter::Move()
{
	_direction = _velocity + (_world->dt())*_acceleration;
	_speed = _direction.MagnitudeNormalize();
	CLAMP(_speed, _minspeed, _maxspeed);
	_velocity = _speed * _direction;
 	_position += (_world->dt())*_velocity;
	// Now we do something to keep from running outside the window.
	if (_world->wrapflag())
		_world->box().Wrap(_position);
	else
	{
		_world->ClampBounce(_position, _direction);
		_velocity = _speed * _direction;
	}
}

int Critter::value(Critter * othercritter)
{
	return _owner->value(this, othercritter);
}

void Critter::Collide(Critter *othercritter)
{
	bumpScore(value(othercritter));
}

//============Child Critters====================
CursorCritter::CursorCritter()
{
	_cursor_move_response = 1.0;
}

WanderCritter::WanderCritter()
{
	_minspeed = (MIN_SPEED + MAX_SPEED) / 2.0;
	_maxspeed = MAX_SPEED;
	_max_direction_change = rrRandomreal(PI/10.0, PI/2.0);
	_max_speed_change = rrRandomreal(0.2, 2.0); //percent change
	_change_time = 0.03;
}

SpringCritter::SpringCritter()
{
	_spring_constant = rrRandomreal(0.05, 0.4);
}

GravityCritter::GravityCritter()
{
	_gravity_constant = rrRandomreal(1.0, 10.0);
	_repelling_force = rrRandomreal(10.0, 100.0);
}

SpringGravityCritter::SpringGravityCritter()
{
	_spring_constant = rrRandomreal(10.0, 3.0);
	_gravity_constant = -rrRandomreal(6.0, 3.0);
	_repelling_force = rrRandomreal(10.0, 1000.0);
}


PredatorPreyCritter::PredatorPreyCritter()
{
	_predator_force = -50.0;
	_prey_force = 50.0;
	_repelling_force = rrRandomreal(1.0, 10.0);
}
//======================================================
void WanderCritter::Move()
{
#ifdef CRUDE_WANDER
	_direction.Rotate(rrRandomsignreal()*_max_direction_change);
	_speed += rrRandomsignreal() * _max_speed_change;
	_velocity = _speed * _direction;
#else
	static Real wait_time = 0.0;
	static Vector2 acceleration;

	if (!wait_time)
	{
		Vector2 newvelocity = (_speed +  (rrRandomsignreal() * 
			_max_speed_change)) *
			_direction.Rotate(rrRandomsignreal()*_max_direction_change);
		acceleration = (newvelocity - _velocity);
		/* This is the amount of acceleration to achieve over the
			_change_time.
		This will be _change_time / _world->dt() steps long.  So do
		acceleration *= _world->dt() / _change_time.  But at each step we
		only add in _world->dt() times the proper amount.  So do
		acceleration *= 1/world-dt(); Combining, we get this: */
		if (_change_time < SMALL_REAL)
			_change_time = SMALL_REAL; //To avoid divide by zero.
		acceleration *= 1/_change_time;
	}
	_acceleration = acceleration;
	wait_time += _world->dt();
	if (wait_time > _world->dt())
		wait_time = 0.0;
#endif //not CRUDE_WANDER
	Critter::Move();
}

void CursorCritter::Move()
{ /* We don't want to do physics here and accumulate momentum.  Just follow
the cursor, but maybe take a few steps to get there. */
	_position += (_world->cursorvector() - _position) *
		_cursor_move_response;
	_world->box().Clamp(_position);
}

void PredatorPreyCritter::Move()
{
	Vector2 to_nearest;
	Real distance_to_nearest;
	Critter *nearest_prey = _owner->ClosestCritter(this, _prey_critter);
	Critter *nearest_predator = _owner->ClosestCritter(this, _predator_critter);
	Critter *nearest = _owner->ClosestCritter(this); //NULL if there's only one critter.

	_acceleration = Vector2(0.0,0.0);
	if (nearest_prey)
	{
		to_nearest = _owner->direction(this, nearest_prey);
		distance_to_nearest = _owner->distance(this, nearest_prey);
		/* Since we are calling updateMetric, not updateAndNormalizeMetric,
		to_nearest is not a unit vector.  So now we normalize it.  Note that
		we have defined the Vector2::operator/= so that it checks for division
		by 0 and does something reasonable in this case, i.e. divides by
		SMALL_REAL */
#ifndef UPDATE_NORMALIZE		
		to_nearest /= distance_to_nearest; 
#endif
		if (distance_to_nearest < CATCH_FACTOR * _radius)
		{
			MessageBeep(MB_ICONEXCLAMATION); //Needs sound card
		//	bumpScore(PREY_VALUE);
		//	nearest_prey->bumpScore(PREDATOR_VALUE);
			_acceleration += to_nearest;
		}
		else
			_acceleration += _prey_force  * to_nearest;
	}
	if (nearest_predator)
	{
		to_nearest = _owner->direction(this, nearest_predator);
		distance_to_nearest = _owner->distance(this, nearest_predator);
#ifndef UPDATE_NORMALIZE		
		to_nearest /= distance_to_nearest;  //Safe Vector2 /=
#endif
		if (distance_to_nearest < CATCH_FACTOR * _radius)
		{
			MessageBeep(MB_OK); //Works even without sound card
	//		bumpScore(PREDATOR_VALUE);
	//		nearest_predator->bumpScore(PREY_VALUE);
			_acceleration += DART_FACTOR * _predator_force * rrRandomunitvector();
				//* to_nearest;
		}
		else
			_acceleration += (_predator_force / distance_to_nearest) * to_nearest;
	}
	if (nearest && (nearest != nearest_prey && nearest != nearest_predator))
	{
		to_nearest = _owner->direction(this, nearest);
		distance_to_nearest = _owner->distance(this, nearest);
#ifndef UPDATE_NORMALIZE		
		to_nearest /= distance_to_nearest;  //Safe Vector2 /=
#endif
		if (distance_to_nearest < 2*_radius)
			_acceleration += -_repelling_force * to_nearest;
	}

Critter::Move();
}

void SpringCritter::Move()
{
	Vector2 to_puller;
	Real dist;

	_acceleration = Vector2(0.0, 0.0);
	for (int i=0; i< _pull_critter.GetSize(); i++)
	{
#ifdef UPDATE_NORMALIZE
		to_puller = owner->direction(this, _pull_critter[i]);
		dist = owner->distance(this, _pull_critter[i]);
#else
		to_puller = _pull_critter[i]->position() - _position;
		dist = to_puller.MagnitudeNormalize();
#endif
		_acceleration += _spring_constant * dist * to_puller;
	}
	Critter::Move();
}

void GravityCritter::Move()
{
	Vector2 to_puller;
	Real dist;

	_acceleration = Vector2(0.0, 0.0);
	for (int i=0; i< _pull_critter.GetSize(); i++)
	{
#ifdef UPDATE_NORMALIZE
		to_puller = owner->direction(this, _pull_critter[i]);
		dist = owner->distance(this, _pull_critter[i]);
#else
		to_puller = _pull_critter[i]->position() - _position;
		dist = to_puller.MagnitudeNormalize();
#endif
		if (dist > _radius)
			_acceleration += (_gravity_constant/(dist*dist)) * to_puller;
		else
			_acceleration += -_repelling_force * to_puller;
	}
	Critter::Move();
}

void SpringGravityCritter::Move()
{
	Vector2 to_puller;
	Real dist;

	_acceleration = Vector2(0.0, 0.0);
	for (int i=0; i< _gravity_pull_critter.GetSize(); i++)
	{
#ifdef UPDATE_NORMALIZE
		to_puller = owner->direction(this, _pull_critter[i]);
		dist = owner->distance(this, _pull_critter[i]);
#else
		to_puller = _gravity_pull_critter[i]->position() - _position;
		dist = to_puller.MagnitudeNormalize();
#endif
		if (dist > _radius)
			_acceleration += (_gravity_constant/(dist*dist)) * to_puller;
		else
			_acceleration += -_repelling_force * to_puller;
	}
	for (i=0; i< _spring_pull_critter.GetSize(); i++)
	{
#ifdef UPDATE_NORMALIZE
		to_puller = owner->direction(this, _pull_critter[i]);
		dist = owner->distance(this, _pull_critter[i]);
#else
		to_puller = _spring_pull_critter[i]->position() - _position;
		dist = to_puller.MagnitudeNormalize();
#endif
		_acceleration += _spring_constant * dist * to_puller;
	}
	Critter::Move();
}

//================== CritterList =================================

OwnerCritterList::~OwnerCritterList()
{
	for (int i=0; i<_critter.GetSize(); i++)
		delete _critter[i];
//And now the parent destructor is called to delete the array itself.
}

//-------------Mutators-------------------
void OwnerCritterList::SetWorld(World *world)
{
	for (int i=0; i<_critter.GetSize(); i++)
		_critter[i]->SetWorld(world);
}

void OwnerCritterList::RandomizePositionVelocity()
{
	for (int i=0; i<_critter.GetSize(); i++)
		_critter[i]->RandomizePositionVelocity();
}

void OwnerCritterList::Add(Critter *addcritter)
{
	/* We mustn't ever add a critter twice because then if we are an
	OwnerCritterList, our destructor would call delete on the same pointer
	twice, which will crash. */
	for (int i=0; i< _critter.GetSize(); i++)
		if (_critter[i] == addcritter)
			return;
	_critter.Add(addcritter);
	/* Tell the critter it belongs to this list, and tell it what its index
		position in this list is. */
	addcritter->_owner = this; 
	addcritter->_owner_index = _critter.GetSize() - 1;
	if (!_focus) //This is the case if you're adding your first critter.
		_focus = addcritter;
	// Adjust the  _metric to the proper size.
	_metric.setOwnerCritterList(this);
	/*  Sets size and fills in the "diagonal" values as 0.0 for accuracy,
		as you won't be recomputing these values in _metric.update(). */
	_ecology.setOwnerCritterList(this); // adjusts size, sets all values to 0.
}

//--------------Accessor------------------------
Critter*& OwnerCritterList::operator[](int index) 
{ /* For just getting the value; you can't use this to change the
value of _critter[i],	if you wanted to do that, you'd use the operator[] and
have the return type be Critter*& */
	if (!(0 <= index && index < _critter.GetSize()))
	{// Use the errorBox function from cMemoryDC?.H
		errorBox("CRITTER.CPP", "Parenthesis operator out of range in CritterList");
		return _critter[0];
	}
	return _critter[index];
}

int OwnerCritterList::value(Critter *critteri, Critter *critterj)
{
	return _ecology.value(critteri->_owner_index, critterj->_owner_index);
}

Real OwnerCritterList::distance(Critter *critteri, Critter *critterj) const
{
	return _metric.distance(critteri->owner_index(), critterj->owner_index());
}
			
Vector2 OwnerCritterList::direction(Critter *critteri, Critter *critterj) const
{
	return _metric.direction(critteri->owner_index(), critterj->owner_index());
}
			
//-------------Method-----------------------
BOOL OwnerCritterList::Collide()
{
	BOOL collision = FALSE;

	for (int i=0; i<_critter.GetSize(); i++)
	{
		for (int j=0; j<i; j++)
		{
			if (_metric.distance(i,j) <= _critter[i]->radius() + _critter[j]->radius())
			{
				collision = TRUE;
				_critter[i]->Collide(_critter[j]);
				_critter[j]->Collide(_critter[i]);
			}
		}
	}
	return collision;
}

Critter* OwnerCritterList::ClosestCritter(Critter *basecritter, const CArray<Critter*, Critter*> &critterlist) const
{   /* Return the closest critter in critterlist which is not equal to basecritter.
	If there is no such critter return NULL.  Note that for this to work right,
	you have to have called OwnerCritterList::updateMetric or  OwnerCritterList::updateAndNormalizeMetric()
	before calling ClosestCritter.*/

	Critter *closest_critter;
	int startindex;
	Real closest_distance;

	if (!critterlist.GetSize())
		return NULL;
	if (critterlist.GetSize() == 1)
	{
		if (basecritter == critterlist[0])
			return NULL;
		else
			return critterlist[0];
	}
//If we have at least two critters in the list, choose one different from 
//basecritter.
	if (basecritter == critterlist[0])
	{
		closest_critter = critterlist[1];
		startindex = 2;
	}
	else
	{
		closest_critter = critterlist[0];
		startindex = 1;
	}
	closest_distance =  distance(closest_critter, basecritter);
	for (int i= startindex; i< critterlist.GetSize(); i++)
	{
		if (distance(critterlist[i], basecritter) < closest_distance && 
			critterlist[i] != basecritter)
		{
			closest_distance = distance(critterlist[i], basecritter);
			closest_critter = critterlist[i];
		}
	}
	return closest_critter;
}

Critter* OwnerCritterList::ClosestCritter(Critter *basecritter) const
{
	return ClosestCritter(basecritter, _critter);
}

Critter* OwnerCritterList::ClosestCritter(const Vector2 &location) const
{
	Critter *closest_critter;
	Real dist, closest_distance;

	if (!_critter.GetSize())
		return NULL;
	closest_critter = _critter[0];
	closest_distance =  (location - _critter[0]->position()).Magnitude();
	for (int i=1; i< _critter.GetSize(); i++)
	{
		dist = (location - _critter[i]->position()).Magnitude();
		if (dist < closest_distance)
		{
			closest_distance = dist;
			closest_critter = _critter[i];
		}
	}
	return closest_critter;
}

Critter* OwnerCritterList::SetFocusByCursor() //Set _focus to _critter[i] closest to cursor.
{
	_focus = ClosestCritter((_critter[0]->_world)->cursorvector());
	return _focus;
}

void OwnerCritterList::Move()
{
	for (int i=0; i<_critter.GetSize(); i++)
		if (_critter[i]->alive())
			_critter[i]->Move();
}

void OwnerCritterList::Show(CDC *pDC, const Frame &frame)
{
	for (int i=0; i<_critter.GetSize(); i++)
		if (_critter[i]->alive())
			_critter[i]->Show(pDC, frame);
}


void OwnerCritterList::scaleIcon(Real scalefactor_x, Real scalefactor_y)
{
	for (int i=0; i<_critter.GetSize(); i++)
		_critter[i]->scaleIcon(scalefactor_x, scalefactor_y);
}

void OwnerCritterList::updateMetric()
{
	_metric.update();
}

void OwnerCritterList::updateAndNormalizeMetric()
{
	_metric.updateAndNormalize();
}

//-----------------Metric Methods---------------------------------
inline int cMetric::_index(int i, int j) const
{
	return i + j * _pOwnerCritterList->size();
}

void cMetric::setOwnerCritterList(OwnerCritterList* pOwnerCritterList_new)
{
	_pOwnerCritterList = pOwnerCritterList_new;
	_cArrayMetricEntry.SetSize(_pOwnerCritterList->size() * _pOwnerCritterList->size());
	for (int i=0; i< _pOwnerCritterList->size(); i++)
		_cArrayMetricEntry[_index(i,i)] = cMetricEntry();
}

void cMetric::updateAndNormalize()
{
/* We keep the _metric array symmetric, so we only need to compute the
_metric(_index(i,j)) for i < j, and copy the values to the (j, i) pair.
Note that the (i, i) values are fixed at 0.0, they get set in
OwnerCritterList::Add.  */
	for (int i=0; i< _pOwnerCritterList->size(); i++)
		for (int j = 0; j<i; j++)
		{
			int index = _index(i,j);
			_cArrayMetricEntry[index]._v2Direction = 
				(*_pOwnerCritterList)[j]->position() -
				(*_pOwnerCritterList)[i]->position();
			_cArrayMetricEntry[index]._rDistance = 
				_cArrayMetricEntry[index]._v2Direction.MagnitudeNormalize();
			_cArrayMetricEntry[_index(j, i)] = _cArrayMetricEntry[index];
		}
}

void cMetric::update()
{
/* We keep the _metric array symmetric, so we only need to compute the
_metric(_index(i,j)) for i < j, and copy the values to the (j, i) pair.
Note that the (i, i) values are fixed at 0.0, they get set in
OwnerCritterList::Add.  */
	for (int i=0; i< _pOwnerCritterList->size(); i++)
		for (int j = 0; j<i; j++)
		{
			int index = _index(i,j);
			_cArrayMetricEntry[index]._v2Direction = 
				(*_pOwnerCritterList)[j]->position() -
				(*_pOwnerCritterList)[i]->position();
			_cArrayMetricEntry[index]._rDistance = 
				_cArrayMetricEntry[index]._v2Direction.Magnitude();
			_cArrayMetricEntry[_index(j, i)] = _cArrayMetricEntry[index];
		}
}

Real cMetric::distance(int i, int j) const
{
	int index = _index(i, j);
	return _cArrayMetricEntry[index]._rDistance;
}

Vector2 cMetric::direction(int i, int j) const
{
	int index = _index(i, j);
	return _cArrayMetricEntry[index]._v2Direction;
}

//--------------------Ecology methods--------------------
inline int cEcology::_index(int i, int j) const
{
	return i + j * _pOwnerCritterList->size();
}

void cEcology::setOwnerCritterList(OwnerCritterList* pOwnerCritterList_new)
{
	_pOwnerCritterList = pOwnerCritterList_new;
	_cArrayEcology.SetSize(_pOwnerCritterList->size() * _pOwnerCritterList->size());
	for (int i=0; i< _pOwnerCritterList->size(); i++)
	for (int j=0; j< _pOwnerCritterList->size(); j++)
		_cArrayEcology[_index(i,j)] = 0;
}

int cEcology::value(int i, int j) const
{
	return _cArrayEcology[_index(i, j)];
}

void cEcology::setValue(int i, int j, int val)
{
	_cArrayEcology[_index(i, j)] = val;	
}

